const transporter = require('../helpers/transporter');
const { resetPasswordEmailTemplate } = require('../templates/email');

const forgotPasswordEmail = (username, clientEmail, token) => {
	const htmlMessage = resetPasswordEmailTemplate(username, token);
	return {
		from: process.env.EMAIL_USER,
		to: clientEmail,
		subject: 'Forgot Password',
		html: htmlMessage,
	};
};

const sendEmail = async (options) => {
	try {
		await transporter.sendMail(options);
		return true;
	} catch (error) {
		console.log(error);
		return false;
	}
};

module.exports = { forgotPasswordEmail, sendEmail };
