'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		await queryInterface.bulkInsert('bookings', bookingData);

		const IDS = bookingData.map((item) => ({
			booking_id: item.id,
		}));

		await queryInterface.bulkInsert(
			'payment_history',
			[
				{
					id: generateRandomId(),
					payout_method: 'Credit Card',
					total: 250.0,
					expected_payout: new Date(new Date().setDate(new Date().getDate() - 10)).toISOString().split('T')[0], // 10 days ago
					status: 'Completed',
					customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
					host_id: generateRandomId(),
					...IDS[0],
				},
				{
					id: generateRandomId(),
					payout_method: 'PayPal',
					total: 175.5,
					expected_payout: new Date().toISOString().split('T')[0], // today's date
					status: 'Upcoming',
					customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
					host_id: generateRandomId(),
					...IDS[1],
				},
				{
					id: generateRandomId(),
					payout_method: 'Bank Transfer',
					total: 300.0,
					expected_payout: new Date(new Date().setDate(new Date().getDate() + 10)).toISOString().split('T')[0], // 10 days from now
					status: 'Upcoming',
					customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
					host_id: generateRandomId(),
					...IDS[2],
				},
				{
					id: generateRandomId(),
					payout_method: 'Stripe',
					total: 120.75,
					expected_payout: new Date(new Date().setDate(new Date().getDate() + 15)).toISOString().split('T')[0], // 15 days from now
					status: 'Upcoming',
					customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
					host_id: generateRandomId(),
					...IDS[3],
				},
				{
					id: generateRandomId(),
					payout_method: 'Apple Pay',
					total: 400.0,
					expected_payout: new Date(new Date().setDate(new Date().getDate() + 20)).toISOString().split('T')[0], // 20 days from now
					status: 'Upcoming',
					customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
					host_id: generateRandomId(),
					...IDS[4],
				},
			],
			{},
		);
	},

	async down(queryInterface, Sequelize) {
		await queryInterface.bulkDelete('payment_history', null, {});
	},
};

const bookingData = [
	{
		id: generateRandomId(),
		customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
		listing_id: '0f0057b3-f4a8-426e-8988-bd79a84ea8e3',
		host_id: generateRandomId(),
		booking_no: 'BK001',
		check_in: new Date(new Date().setDate(new Date().getDate() - 5)).toISOString().split('T')[0], // 5 days ago
		check_out: new Date(new Date().setDate(new Date().getDate() + 5)).toISOString().split('T')[0], // 5 days from now
		pax: 2,
		price_per_night: 100.0,
		service_fee: 10.0,
		add_ons_total: 20.0,
		total_amount: 230.0,
		payment_option: 'Pay Now',
		amount_paid: 230.0,
		payment_status: 'Fully Paid',
		balance: 0.0,
		phone_no: '1234567890',
		payment_method: 'Online',
		message_to_host: 'Looking forward to our stay!',
		user_image: 'path/to/image.jpg',
		status: 'Upcoming',
		createdAt: new Date(),
		updatedAt: new Date(),
	},
	{
		id: generateRandomId(),
		customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
		host_id: generateRandomId(),
		listing_id: '3f6e9cc6-dd8f-4816-8add-1eab60e17dd8',
		booking_no: 'BK002',
		check_in: new Date(new Date().setDate(new Date().getDate() - 3)).toISOString().split('T')[0], // 3 days ago
		check_out: new Date(new Date().setDate(new Date().getDate() + 7)).toISOString().split('T')[0], // 7 days from now
		pax: 4,
		price_per_night: 150.0,
		service_fee: 15.0,
		add_ons_total: 30.0,
		total_amount: 345.0,
		payment_option: 'Installment',
		amount_paid: 100.0,
		payment_status: 'Partially Paid',
		balance: 245.0,
		phone_no: '0987654321',
		payment_method: 'Cash',
		message_to_host: 'Can we check in early?',
		user_image: 'path/to/image2.jpg',
		status: 'Upcoming',
		createdAt: new Date(),
		updatedAt: new Date(),
	},
	{
		id: generateRandomId(),
		customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
		host_id: generateRandomId(),
		listing_id: '0a074a17-2270-47a2-865e-b29d241a5fc7',
		pax: 3,
		booking_no: 'BK006',
		check_in: new Date(new Date().setDate(new Date().getDate() - 2)).toISOString().split('T')[0], // 2 days ago
		check_out: new Date(new Date().setDate(new Date().getDate() + 8)).toISOString().split('T')[0], // 8 days from now
		price_per_night: 120.0,
		service_fee: 12.0,
		add_ons_total: 25.0,
		total_amount: 377.0,
		payment_option: 'Pay Now',
		amount_paid: 377.0,
		payment_status: 'Fully Paid',
		balance: 0.0,
		phone_no: '1122334455',
		payment_method: 'Debit/Credit',
		message_to_host: 'Thank you!',
		user_image: 'path/to/image3.jpg',
		status: 'Upcoming',
		createdAt: new Date(),
		updatedAt: new Date(),
	},
	{
		id: generateRandomId(),
		customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
		host_id: generateRandomId(),
		listing_id: '0f0057b3-f4a8-426e-8988-bd79a84ea8e3',
		booking_no: 'BK004',
		check_in: new Date(new Date().setDate(new Date().getDate() - 2)).toISOString().split('T')[0], // 2 days ago
		check_out: new Date(new Date().setDate(new Date().getDate() + 8)).toISOString().split('T')[0], // 8 days from now
		pax: 1,
		price_per_night: 80.0,
		service_fee: 8.0,
		add_ons_total: 15.0,
		total_amount: 183.0,
		payment_option: 'Pay Now',
		amount_paid: 183.0,
		payment_status: 'Fully Paid',
		balance: 0.0,
		phone_no: '2233445566',
		payment_method: 'Online',
		message_to_host: 'Excited for the trip!',
		user_image: 'path/to/image4.jpg',
		status: 'Upcoming',
		createdAt: new Date(),
		updatedAt: new Date(),
	},
	{
		id: generateRandomId(),
		customer_id: '787b2c9a-062e-4597-94e7-8ee7a33534bb',
		host_id: generateRandomId(),
		listing_id: '3f6e9cc6-dd8f-4816-8add-1eab60e17dd8',
		booking_no: 'BK005',
		check_in: new Date(new Date().setDate(new Date().getDate() - 4)).toISOString().split('T')[0], // 4 days ago
		check_out: new Date(new Date().setDate(new Date().getDate() + 6)).toISOString().split('T')[0], // 6 days from now
		pax: 5,
		price_per_night: 200.0,
		service_fee: 20.0,
		add_ons_total: 40.0,
		total_amount: 460.0,
		payment_option: 'Installment',
		amount_paid: 200.0,
		payment_status: 'Partially Paid',
		balance: 260.0,
		phone_no: '3344556677',
		payment_method: 'Cash',
		message_to_host: 'Can we get an extra bed?',
		user_image: 'path/to/image5.jpg',
		status: 'Upcoming',
		createdAt: new Date(),
		updatedAt: new Date(),
	},
];

function generateRandomId() {
	return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
		var r = (Math.random() * 16) | 0,
			v = c == 'x' ? r : (r & 0x3) | 0x8;
		return v.toString(16);
	});
}
