const express = require('express');
const { validation, isAuth } = require('../../../middlewares');
const { updatePrivacyFlags, getPrivacyFlags } = require('../../../controllers/users/privacy-flags');
const { body } = require('express-validator');

const router = express.Router();

router.patch(
	'/',
	isAuth,
	[
		body('readReceipts').isBoolean().optional(),
		body('viewMyOnListings').isBoolean().optional(),
		body('displayMyLocation').isBoolean().optional(),
		body('displayTripDetails').isBoolean().optional(),
		body('displayDurationOfVisit').isBoolean().optional(),
	],
	validation,
	updatePrivacyFlags,
);

router.get('/', isAuth, getPrivacyFlags);

module.exports = router;
