const express = require('express');
const { body } = require('express-validator');
const { validation, isAuth } = require('../../../middlewares');
const {
	sendMessage,
	getAllMessagesByConvoId,
	getAllConvoByUser,
	seenMessages,
} = require('../../../controllers/users/chat-system');
const { jsonParser } = require('../../../helpers');

const router = express.Router();

router.post(
	'/',
	isAuth,
	jsonParser,
	[body('data.convoId').optional(), body('data.content').notEmpty(), body('data.receiverId').optional()],
	validation,
	sendMessage,
);

router.get('/:convoId', isAuth, getAllMessagesByConvoId);
router.get('/', isAuth, getAllConvoByUser);
router.patch('/:convoId', isAuth, seenMessages);

module.exports = router;
