const express = require('express');
const { isAuth } = require('../../../middlewares');
const {
	getRecentBookingsByCustomerId,
	getAllBookings,
	getBookingsByReferenceNo,
	deleteCancelledBooking,
} = require('../../../controllers/host/bookings');

const router = express.Router();

router.get('/:customerId', isAuth, getRecentBookingsByCustomerId);
router.get('/search/:bookingNo', isAuth, getBookingsByReferenceNo);
router.get('/', isAuth, getAllBookings);
router.delete('/:bookingId', isAuth, deleteCancelledBooking);

module.exports = router;
