const express = require('express');
const { body } = require('express-validator');
const { validation, isAuth } = require('../../../middlewares');
const {
	applyHost,
	getMyApplications,
	approveApplication,
	getApplicationById,
} = require('../../../controllers/host/apply');
const { jsonParser } = require('../../../helpers');

const router = express.Router();

router.post(
	'/',
	isAuth,
	jsonParser,
	[
		body('data.cityToHost').notEmpty(),
		body('data.languages').notEmpty(),
		body('data.isPartnerOrg').notEmpty(),
		body('data.aboutMe').optional(),
		body('data.themes').notEmpty(),
		body('data.description').optional(),
		body('data.duration').optional(),
		body('data.locationType').notEmpty(),
		body('data.locationDescription').optional(),
		body('data.hostingType').notEmpty(),
		body('data.addressCountry').notEmpty(),
		body('data.addressStreet').notEmpty(),
		body('data.addressApt').optional({
			values: 'falsy',
		}),
		body('data.addressCity').notEmpty(),
		body('data.addressState').notEmpty(),
		body('data.addressZip').notEmpty(),
		body('data.locationLat').notEmpty(),
		body('data.locationLong').notEmpty(),
		body('data.amenities').notEmpty(),
		body('data.services').optional(),
		body('data.listingName').notEmpty(),
		body('data.capacity').notEmpty(),
		body('data.individualRate').notEmpty(),
		body('data.travelersDiscounts').notEmpty(),
		body('data.checkInTime').notEmpty(),
		body('data.checkOutTime').notEmpty(),
		body('data.cancellationPolicy').notEmpty(),
	],
	validation,
	applyHost,
);

router.get('/', isAuth, getMyApplications);
router.patch('/:applicationId', approveApplication);
router.get('/:applicationId', isAuth, getApplicationById);

module.exports = router;
