const express = require('express');
const {
	getRecentlyViewed,
	createRecentlyViewed,
	deleteRecentlyViewed,
} = require('../../../controllers/customers/listings');
const { isAuth } = require('../../../middlewares');
const router = express.Router();

router.get('/', isAuth, getRecentlyViewed);
router.post('/:listingId', isAuth, createRecentlyViewed);
router.delete('/:recentlyViewedListingId', isAuth, deleteRecentlyViewed);

module.exports = router;
