const express = require('express');
const { isAuth, validation } = require('../../../middlewares');
const {
	getFavorites,
	createFavorite,
	deleteFolder,
	deleteFavoriteListing,
	updateFavoriteFolder,
	getFolder,
	getFolders,
} = require('../../../controllers/customers/favorites');
const { body } = require('express-validator');

const router = express.Router();

router.use(isAuth);

router.get('/', getFavorites);
router.get('/folders/:folderId', getFolder);
router.get('/folders', getFolders);

router.post(
	'/',
	[
		body().custom((value, { req }) => {
			if (req.body.folderId && !req.body.listingId) {
				throw new Error('listingId is required when folderId is provided');
			}
			return true;
		}),
		body('name').isString().trim().notEmpty().optional(),
	],
	validation,
	createFavorite,
);
router.patch('/:folderId', updateFavoriteFolder);

router.delete('/folders/:folderId', deleteFolder);
router.delete('/listings/:favoriteListingId', deleteFavoriteListing);

module.exports = router;
