const { UUID, UUIDV4, BOOLEAN } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Users = sequelize.define(
		'UsersPrivacyFlags',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			read_receipts: {
				type: BOOLEAN,
				defaultValue: true,
			},
			view_my_on_listings: {
				type: BOOLEAN,
				defaultValue: true,
			},
			display_my_location: {
				type: BOOLEAN,
				defaultValue: true,
			},
			display_trip_details: {
				type: BOOLEAN,
				defaultValue: true,
			},
			display_duration_of_visit: {
				type: BOOLEAN,
				defaultValue: true,
			},
		},
		{
			tableName: 'users_privacy_flags',
			timestamps: false,
		},
	);

	return Users;
};
