const { UUID, UUIDV4, BOOLEAN } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Users = sequelize.define(
		'UsersFlags',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			stayfinder_latest_features: {
				type: BOOLEAN,
				defaultValue: true,
			},
			stayfinder_latest_features_email: {
				type: BOOLEAN,
				defaultValue: true,
			},
			stayfinder_latest_features_message: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travel_advice: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travel_advice_email: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travel_advice_message: {
				type: BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines: {
				type: BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines_email: {
				type: BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines_message: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages_email: {
				type: BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages_message: {
				type: BOOLEAN,
				defaultValue: true,
			},
		},
		{
			tableName: 'users_flags',
			timestamps: false,
		},
	);

	return Users;
};
