const { UUID, UUIDV4, STRING, DATE, TEXT } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const RefreshTokens = sequelize.define(
		'RefreshTokens',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: true,
			},
			token: {
				type: TEXT,
				allowNull: false,
			},
			expiration_date: {
				type: DATE,
				allowNull: false,
			},
			refresh_token: {
				type: TEXT,
				allowNull: false,
			},
			refresh_token_expiration_date: {
				type: DATE,
				allowNull: false,
			},
			browser: {
				type: STRING,
				allowNull: false,
			},
			os: {
				type: TEXT,
				allowNull: true,
			},
			device: {
				type: TEXT,
				allowNull: true,
			},
			device_id: {
				type: TEXT,
				allowNull: true,
			},
		},
		{
			tableName: 'refresh_tokens',
			timestamps: true,
		},
	);

	return RefreshTokens;
};
