const { UUID, UUIDV4 } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const RecentlyViewedListings = sequelize.define(
		'RecentlyViewedListings',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			host_id: {
				type: UUID,
				allowNull: false,
			},
		},
		{
			tableName: 'recently_viewed_listings',
			timestamps: true,
		},
	);

	RecentlyViewedListings.associate = (models) => {
		RecentlyViewedListings.belongsTo(models.Listings, {
			foreignKey: 'listing_id',
			as: 'listing',
		});
	};

	return RecentlyViewedListings;
};
