'use strict';

module.exports = (sequelize, DataTypes) => {
	const PaymentHistory = sequelize.define(
		'PaymentHistory',
		{
			id: {
				type: DataTypes.UUID,
				defaultValue: DataTypes.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			customer_id: {
				type: DataTypes.UUID,
				allowNull: false,
			},
			host_id: {
				type: DataTypes.UUID,
				allowNull: false,
			},
			booking_id: {
				type: DataTypes.UUID,
				allowNull: false,
			},
			payout_method: {
				type: DataTypes.STRING,
				allowNull: false,
			},
			expected_payout: {
				type: DataTypes.DATEONLY,
				allowNull: false,
			},
			total: {
				type: DataTypes.DECIMAL(10, 2),
				allowNull: false,
			},
			status: {
				type: DataTypes.ENUM('Upcoming', 'Completed'),
				allowNull: false,
				defaultValue: 'Upcoming',
			},
			createdAt: {
				type: DataTypes.DATE,
				allowNull: false,
				defaultValue: DataTypes.NOW,
			},
			updatedAt: {
				type: DataTypes.DATE,
				allowNull: false,
				defaultValue: DataTypes.NOW,
			},
		},
		{
			tableName: 'payment_history',
			timestamps: true,
		},
	);

	PaymentHistory.associate = (models) => {
		PaymentHistory.belongsTo(models.Users, {
			foreignKey: 'customer_id',
			onDelete: 'CASCADE',
			as: 'customer',
		});
		PaymentHistory.belongsTo(models.Users, {
			foreignKey: 'host_id',
			onDelete: 'CASCADE',
			as: 'host',
		});
		PaymentHistory.belongsTo(models.Bookings, {
			foreignKey: 'booking_id',
			onDelete: 'CASCADE',
		});
	};

	return PaymentHistory;
};
