const { UUID, UUIDV4, DECIMAL, STRING, TEXT, DOUBLE, INTEGER, ENUM, TIME, BOOLEAN, JSON } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Listings = sequelize.define(
		'Listings',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: UUID,
				allowNull: false,
			},
			name: {
				type: STRING(50),
				allowNull: false,
			},
			description: {
				type: TEXT,
				allowNull: true,
			},
			location_type: {
				type: JSON,
				allowNull: false,
			},
			address_country: {
				type: STRING,
				allowNull: false,
			},
			address_street: {
				type: STRING,
				allowNull: false,
			},
			address_apt: {
				type: STRING,
				allowNull: true,
			},
			address_city: {
				type: STRING,
				allowNull: false,
			},
			address_state: {
				type: STRING,
				allowNull: false,
			},
			address_zip: {
				type: STRING,
				allowNull: false,
			},
			longitude: {
				type: DOUBLE,
				allowNull: false,
			},
			latitude: {
				type: DOUBLE,
				allowNull: false,
			},
			price: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			min_capacity: {
				type: INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			max_capacity: {
				type: INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			amenities: {
				type: JSON,
				allowNull: true,
			},
			services: {
				type: JSON,
				allowNull: true,
			},
			check_in_time: {
				type: TIME,
				allowNull: false,
			},
			check_out_time: {
				type: TIME,
				allowNull: false,
			},
			cancellation_policy: {
				type: ENUM(
					'Cancellation and Refund Policy: 7-day full refund; 24-hour grace period (48-hour advance booking required)',
					'24-Hour Cancellation Window: Full Refund Guaranteed',
				),
				allowNull: true,
			},
			status: {
				type: ENUM('Active', 'Inactive'),
				allowNull: false,
				defaultValue: 'Active',
			},
			bathroom: {
				type: INTEGER,
				allowNull: true,
			},
			kitchen: {
				type: INTEGER,
				allowNull: true,
			},
			bedroom: {
				type: INTEGER,
				allowNull: true,
			},
			guidelines: {
				type: TEXT,
				allowNull: true,
			},
			safety_and_security: {
				type: TEXT,
				allowNull: true,
			},
			is_deleted: {
				type: BOOLEAN,
				defaultValue: false,
			},
		},
		{
			tableName: 'listings',
			timestamps: true,
		},
	);

	Listings.hasMany(sequelize.models.ListingImages, {
		foreignKey: 'listing_id',
		onDelete: 'CASCADE',
		as: 'listingImages',
	});

	Listings.hasMany(sequelize.models.ListingReviews, {
		foreignKey: 'listing_id',
		onDelete: 'CASCADE',
		as: 'listingReviews',
	});

	Listings.associate = function (models) {
		Listings.belongsTo(models.Users, {
			foreignKey: 'host_id',
			as: 'host',
		});
	};

	return Listings;
};
