const { UUID, UUIDV4, STRING, TEXT, INTEGER } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const ListingReviews = sequelize.define(
		'ListingReviews',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			rating: {
				type: INTEGER,
				allowNull: false,
			},
			content: {
				type: TEXT,
				allowNull: true,
			},
		},
		{
			tableName: 'listing_reviews',
			timestamps: true,
		},
	);

	return ListingReviews;
};
