const { ENUM, UUID, UUIDV4, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const HostNotifications = sequelize.define(
		'HostNotifications',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: UUID,
				allowNull: false,
			},
			booking_id: {
				type: UUID,
				allowNull: false,
			},
			notif_type: {
				type: ENUM('Check-In', 'New Booking', 'Other'),
				allowNull: false,
			},
			message: {
				type: STRING(100),
				allowNull: true,
			},
			status: {
				type: ENUM('Unread', 'Read'),
				defaultValue: 'Unread',
			},
		},
		{
			tableName: 'host_notifications',
			timestamps: true,
		},
	);

	return HostNotifications;
};
