const { UUID, UUIDV4, STRING, DATE } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const FavoriteFolders = sequelize.define(
		'FavoriteFolders',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			folder_name: {
				type: STRING(100),
				allowNull: false,
			},
			createdAt: {
				type: DATE,
				allowNull: false,
			},
			updatedAt: {
				type: DATE,
				allowNull: false,
			},
		},
		{
			tableName: 'favorite_folders',
			timestamps: true,
		},
	);

	FavoriteFolders.associate = (models) => {
		FavoriteFolders.hasMany(models.FavoriteFolderListings, {
			foreignKey: 'folder_id',
			as: 'favoriteListings',
		});
	};

	return FavoriteFolders;
	return FavoriteFolders;
};
