const { UUID, UUIDV4 } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const FavoriteFolderListings = sequelize.define(
		'FavoriteFolderListings',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			folder_id: {
				type: UUID,
				allowNull: true,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
		},
		{
			tableName: 'favorite_folder_listings',
			timestamps: true,
		},
	);

	FavoriteFolderListings.associate = (models) => {
		FavoriteFolderListings.belongsTo(models.Listings, {
			foreignKey: 'listing_id',
			as: 'listing',
		});
	};

	return FavoriteFolderListings;
	return FavoriteFolderListings;
};
