const { UUID, UUIDV4, DECIMAL, ENUM, INTEGER, DATE, TEXT, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Discounts = sequelize.define(
		'Discounts',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			name: {
				type: STRING(100),
				allowNull: false,
			},
			description: {
				type: TEXT,
				allowNull: true,
			},
			code: {
				type: STRING(10),
				allowNull: false,
			},
			type: {
				type: ENUM('Capacity To Reach', 'By Percentage', 'Amount To Reach'),
				allowNull: true,
			},
			percentage: {
				type: DECIMAL(10, 2),
				allowNull: true,
			},
			num_of_pax: {
				type: INTEGER,
				allowNull: true,
			},
			amount: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			validity_start_date: {
				type: DATE,
				allowNull: true,
			},
			validity_end_date: {
				type: DATE,
				allowNull: false,
			},
		},
		{
			tableName: 'discounts',
			timestamps: true,
		},
	);

	return Discounts;
};
