const { UUID, UUIDV4, TEXT, INTEGER } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const CustomerReviews = sequelize.define(
		'CustomerReviews',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: UUID,
				allowNull: false,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			rating: {
				type: INTEGER,
				allowNull: false,
			},
			content: {
				type: TEXT,
				allowNull: true,
			},
		},
		{
			tableName: 'customer_reviews',
			timestamps: true,
		},
	);

	CustomerReviews.associate = function (models) {
		CustomerReviews.belongsTo(models.Users, {
			foreignKey: 'user_id',
			as: 'reviewer',
		});

		CustomerReviews.belongsTo(models.Users, {
			foreignKey: 'host_id',
			as: 'host',
		});
	};

	return CustomerReviews;
};
