const { UUID, UUIDV4, STRING, ENUM } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Conversations = sequelize.define(
		'Conversations',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			name: {
				type: STRING,
				allowNull: true,
			},
			convo_type: {
				type: ENUM('Private', 'Group'),
				allowNull: false,
				defaultValue: 'Private',
			},
			status: {
				type: ENUM('Active', 'Archived'),
				allowNull: false,
				defaultValue: 'Active',
			},
		},
		{
			tableName: 'conversations',
			timestamps: true,
		},
	);

	Conversations.associate = function (models) {
		Conversations.hasMany(models.ConversationMembers, {
			foreignKey: 'convo_id',
			as: 'members',
		});

		Conversations.hasMany(models.Messages, {
			foreignKey: 'convo_id',
			as: 'messages',
		});
	};

	return Conversations;
};
