'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction(async (transaction) => {
			await queryInterface.bulkDelete('users_flags', {
				user_id: {
					[Sequelize.Op.notIn]: Sequelize.literal('(SELECT id FROM users)'),
				},
			});

			await queryInterface.bulkDelete('users_privacy_flags', {
				user_id: {
					[Sequelize.Op.notIn]: Sequelize.literal('(SELECT id FROM users)'),
				},
			});

			await queryInterface.bulkDelete('payment_history', {
				[Sequelize.Op.or]: [
					{
						customer_id: {
							[Sequelize.Op.notIn]: Sequelize.literal('(SELECT id FROM users)'),
						},
					},
					{
						host_id: {
							[Sequelize.Op.notIn]: Sequelize.literal('(SELECT id FROM users)'),
						},
					},
				],
			});

			await queryInterface.addConstraint('users_flags', {
				fields: ['user_id'],
				type: 'foreign key',
				name: 'fk_users_flags_user_id',
				references: {
					table: 'users',
					field: 'id',
				},
				onDelete: 'cascade',
				transaction,
			});

			await queryInterface.addConstraint('users_privacy_flags', {
				fields: ['user_id'],
				type: 'foreign key',
				name: 'fk_users_privacy_flags_user_id',
				references: {
					table: 'users',
					field: 'id',
				},
				onDelete: 'cascade',
				transaction,
			});

			await queryInterface.changeColumn(
				'payment_history',
				'customer_id',
				{
					allowNull: true,
					type: Sequelize.UUID,
				},
				{
					transaction,
				},
			);

			await queryInterface.changeColumn(
				'payment_history',
				'host_id',
				{
					allowNull: true,
					type: Sequelize.UUID,
				},
				{
					transaction,
				},
			);

			await queryInterface.addConstraint('payment_history', {
				fields: ['customer_id'],
				type: 'foreign key',
				name: 'fk_payment_history_customer_id',
				references: {
					table: 'users',
					field: 'id',
				},
				onDelete: 'SET NULL',
				transaction,
			});

			await queryInterface.addConstraint('payment_history', {
				fields: ['host_id'],
				type: 'foreign key',
				name: 'fk_payment_history_host_id',
				references: {
					table: 'users',
					field: 'id',
				},
				onDelete: 'SET NULL',
				transaction,
			});

			await queryInterface.addConstraint('recently_viewed_listings', {
				fields: ['user_id'],
				type: 'foreign key',
				name: 'fk_recently_viewed_listings_user_id',
				references: {
					table: 'users',
					field: 'id',
				},
				onDelete: 'cascade',
				transaction,
			});

			await queryInterface.addConstraint('recently_viewed_listings', {
				fields: ['listing_id'],
				type: 'foreign key',
				name: 'fk_recently_viewed_listings_listing_id',
				references: {
					table: 'listings',
					field: 'id',
				},
				onDelete: 'cascade',
				transaction,
			});
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction(async (transaction) => {
			await queryInterface.removeConstraint('users_flags', 'fk_users_flags_user_id', { transaction });
			await queryInterface.removeConstraint('users_privacy_flags', 'fk_users_privacy_flags_user_id', { transaction });
			await queryInterface.removeConstraint('payment_history', 'fk_payment_history_customer_id', { transaction });
			await queryInterface.removeConstraint('payment_history', 'fk_payment_history_host_id', { transaction });
			await queryInterface.changeColumn(
				'payment_history',
				'customer_id',
				{
					allowNull: false,
					type: Sequelize.UUID,
				},
				{
					transaction,
				},
			);

			await queryInterface.changeColumn(
				'payment_history',
				'host_id',
				{
					allowNull: false,
					type: Sequelize.UUID,
				},
				{
					transaction,
				},
			);
			await queryInterface.removeConstraint('recently_viewed_listings', 'fk_recently_viewed_listings_user_id', {
				transaction,
			});
			await queryInterface.removeConstraint('recently_viewed_listings', 'fk_recently_viewed_listings_listing_id', {
				transaction,
			});
		});
	},
};
