'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('login_sessions', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			address: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			lng: {
				type: Sequelize.DOUBLE,
				allowNull: true,
			},
			lat: {
				type: Sequelize.DOUBLE,
				allowNull: true,
			},
			ip_address: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			browser: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			os: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			device: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});

		await queryInterface.addIndex('login_sessions', ['user_id']);
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('login_sessions');
	},
};
