'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'password_reset_tokens',
					'resent',
					{
						type: Sequelize.BOOLEAN,
						defaultValue: false,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('password_reset_tokens', 'resent', {
					transaction: t,
				}),
			]);
		});
	},
};
