'use strict';

const { TEXT, STRING } = require('sequelize');

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		const { UUID, UUIDV4 } = Sequelize;

		await queryInterface.createTable('password_reset_tokens', {
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			email: {
				type: STRING,
				allowNull: false,
			},
			token: {
				type: TEXT,
				allowNull: false,
			},
			expiry: {
				type: Sequelize.DATE,
				allowNull: false,
			},
		});
	},

	async down(queryInterface, Sequelize) {
		await queryInterface.dropTable('password_reset_tokens');
	},
};
