'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'listings',
					'bathroom',
					{
						type: Sequelize.DataTypes.INTEGER,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'kitchen',
					{
						type: Sequelize.DataTypes.INTEGER,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'bedroom',
					{
						type: Sequelize.DataTypes.INTEGER,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'guidelines',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'safety_and_security',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('listings', 'bathroom', { transaction: t }),
				queryInterface.removeColumn('listings', 'kitchen', { transaction: t }),
				queryInterface.removeColumn('listings', 'bedroom', { transaction: t }),
				queryInterface.removeColumn('listings', 'guidelines', { transaction: t }),
				queryInterface.removeColumn('listings', 'safety_and_security', { transaction: t }),
			]);
		});
	},
};
