'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'users',
					'about_me',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'school',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'work',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'music',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'lived_in',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'languages',
					{
						type: Sequelize.DataTypes.JSON,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'pets',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'hangouts',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'birth_year',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'likes',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'dislikes',
					{
						type: Sequelize.DataTypes.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'interests',
					{
						type: Sequelize.DataTypes.JSON,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'show_travels',
					{
						type: Sequelize.DataTypes.BOOLEAN,
						defaultValue: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'verified',
					{
						type: Sequelize.DataTypes.BOOLEAN,
						defaultValue: false,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('users', 'about_me', { transaction: t }),
				queryInterface.removeColumn('users', 'school', { transaction: t }),
				queryInterface.removeColumn('users', 'work', { transaction: t }),
				queryInterface.removeColumn('users', 'music', { transaction: t }),
				queryInterface.removeColumn('users', 'lived_in', { transaction: t }),
				queryInterface.removeColumn('users', 'languages', { transaction: t }),
				queryInterface.removeColumn('users', 'pets', { transaction: t }),
				queryInterface.removeColumn('users', 'hangouts', { transaction: t }),
				queryInterface.removeColumn('users', 'birth_year', { transaction: t }),
				queryInterface.removeColumn('users', 'likes', { transaction: t }),
				queryInterface.removeColumn('users', 'dislikes', { transaction: t }),
				queryInterface.removeColumn('users', 'interests', { transaction: t }),
				queryInterface.removeColumn('users', 'show_travels', { transaction: t }),
				queryInterface.removeColumn('users', 'verified', { transaction: t }),
			]);
		});
	},
};
