'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'recently_viewed_listings',
					'host_id',
					{
						type: Sequelize.DataTypes.UUID,
						allowNull: false,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('recently_viewed_listings', 'host_id', {
					transaction: t,
				}),
			]);
		});
	},
};
