'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		await queryInterface.createTable('users_flags', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			stayfinder_latest_features: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			stayfinder_latest_features_email: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			stayfinder_latest_features_message: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travel_advice: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travel_advice_email: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travel_advice_message: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines_email: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			account_management_and_guidelines_message: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages_email: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			travelers_and_host_messages_message: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
		});
	},
	async down(queryInterface, Sequelize) {
		await queryInterface.dropTable('users_flags');
	},
};
