'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		await queryInterface.createTable('users_privacy_flags', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			read_receipts: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			view_my_on_listings: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			display_my_location: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			display_trip_details: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
			display_duration_of_visit: {
				type: Sequelize.BOOLEAN,
				defaultValue: true,
			},
		});
	},
	async down(queryInterface, Sequelize) {
		await queryInterface.dropTable('users_privacy_flags');
	},
};
