'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('users', 'address', {
					transaction: t,
				}),
				queryInterface.addColumn(
					'users',
					'address_country',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'address_street',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'address_apt',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'address_city',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'address_state',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'address_zip',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'valid_id_type',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'users',
					'valid_id_image',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'users',
					'address',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.removeColumn('users', 'address_country', { transaction: t }),
				queryInterface.removeColumn('users', 'address_street', { transaction: t }),
				queryInterface.removeColumn('users', 'address_apt', { transaction: t }),
				queryInterface.removeColumn('users', 'address_city', { transaction: t }),
				queryInterface.removeColumn('users', 'address_state', { transaction: t }),
				queryInterface.removeColumn('users', 'address_zip', { transaction: t }),
				queryInterface.removeColumn('users', 'valid_id_type', { transaction: t }),
				queryInterface.removeColumn('users', 'valid_id_image', { transaction: t }),
			]);
		});
	},
};
