'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		const { UUID, UUIDV4, STRING, ENUM } = Sequelize;

		await queryInterface.createTable('host_registration_files', {
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_registration_id: {
				type: UUID,
				allowNull: false,
			},
			file_type: {
				type: ENUM('Listing Images', 'Supporting Documents'),
				allowNull: false,
			},
			file: {
				type: STRING,
				allowNull: false,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('host_registration_files');
	},
};
