'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('host_registrations', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			city_to_hosts: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			languages: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			is_partner_org: {
				type: Sequelize.BOOLEAN,
				defaultValue: false,
			},
			themes: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			duration: {
				type: Sequelize.INTEGER,
				allowNull: false,
			},
			location_type: {
				type: Sequelize.JSON,
				allowNull: false,
			},
			location_description: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			hosting_type: {
				type: Sequelize.ENUM('Self', 'Team'),
				allowNull: false,
			},
			selfie_image: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			about_me: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			location_address: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			location_long: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: true,
			},
			location_lat: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: true,
			},
			amenities: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			services: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			listing_name: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			listing_description: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			listing_images: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			capacity: {
				type: Sequelize.INTEGER,
				allowNull: false,
			},
			individual_rate: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
			},
			check_in_time: {
				type: Sequelize.TIME,
				allowNull: false,
			},
			check_out_time: {
				type: Sequelize.TIME,
				allowNull: false,
			},
			cancellation_policy: {
				type: Sequelize.ENUM(
					'Cancellation and Refund Policy: 7-day full refund; 24-hour grace period (48-hour advance booking required)',
					'24-Hour Cancellation Window: Full Refund Guaranteed',
				),
				allowNull: true,
			},
			status: {
				type: Sequelize.ENUM('Approved', 'Rejected', 'Pending'),
				allowNull: false,
				defaultValue: 'Pending',
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('host_registrations');
	},
};
