'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('users', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			firstname: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			lastname: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			phone_no: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			email_address: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			password: {
				type: Sequelize.STRING,
				allowNull: true,
			},
			birthdate: {
				type: Sequelize.DATEONLY,
				allowNull: true,
			},
			image: {
				type: Sequelize.STRING,
				allowNull: true,
				defaultValue: null,
			},
			is_phone_verified: {
				type: Sequelize.BOOLEAN,
				allowNull: false,
				defaultValue: false,
			},
			is_host: {
				type: Sequelize.BOOLEAN,
				allowNull: false,
				defaultValue: false,
			},
			has_pending_host_application: {
				type: Sequelize.BOOLEAN,
				allowNull: false,
				defaultValue: false,
			},
			status: {
				type: Sequelize.BOOLEAN,
				allowNull: false,
				defaultValue: true,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('users');
	},
};
