const UAParser = require('ua-parser-js');

const getBrowserInfo = (req) => {
	const parser = new UAParser(req.headers['user-agent']);
	const result = parser.getResult();

	return {
		browser: result.browser.name || 'Unknown',
		version: result.browser.version || 'Unknown',
		platform: result.os.name || 'Unknown',
		device: result.device.type ? result.device.type : 'Desktop',
	};
};

module.exports = { getBrowserInfo };
