const crypto = require('node:crypto');

const generateDeviceId = (req) => {
	const userAgent = req.headers['user-agent'] || 'unknown';
	const ip = req.headers['x-forwarded-for'] || req.connection.remoteAddress || 'unknown';

	const hash = crypto.createHash('sha256');
	hash.update(userAgent + ip);
	return hash.digest('hex');
};

module.exports = { generateDeviceId };
