const { LocationTypes } = require('../../models');

exports.getLocationTypes = async (req, res, next) => {
	try {
		const locationTypes = await LocationTypes.findAll({
			attributes: {
				exclude: ['id', 'group'],
			},
		});

		return res.status(200).json({
			success: true,
			data: locationTypes,
		});
	} catch (error) {
		next(error);
	}
};
